/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlock;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientRegistration;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

@WailaPlugin(value="tesseract")
public class TesseractWailaPlugin
implements IComponentProvider,
IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, TesseractBlock.class);
        registration.registerComponentProvider((tooltip, accessor, pluginConfig) -> {
            tooltip.remove(new ResourceLocation("fe"));
            tooltip.remove(new ResourceLocation("fluid"));
        }, TooltipPosition.TAIL, TesseractBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity entity = accessor.getBlockEntity();
        if (entity instanceof TesseractBlockEntity) {
            TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
            tooltip.add((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.channels").get());
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
            if (tesseract.isBlockedByRedstone()) {
                tooltip.add((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").color(ChatFormatting.RED).get());
            }
        }
    }

    private static Component formatChannelInfo(EnumChannelType type, int channelId) {
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
        MutableComponent channelType = TextComponents.fromTextComponent((Component)type.getTranslation()).color(ChatFormatting.GOLD).get();
        MutableComponent separator = TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").get();
        MutableComponent channelName = channel == null ? TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").color(ChatFormatting.DARK_GRAY).italic().get() : TextComponents.string((String)channel.name).get();
        return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).get();
    }
}

